@extends($activeTemplate.'layouts.frontend')
@section('content')
<!-- ==================== Service Start Here ==================== -->
<section class="service-area section-bg py-80 ">
    <div class="container">

        @if ((request()->get('page') == 1 || !request()->get('page')) && $featuredBlog)
        <div class="row">
            <div class="col-12 col-md-8">
                <img src="{{getImage(getFilePath('blog').'/'.$featuredBlog->featured_image)}}" alt="{{ $featuredBlog->title }}" class="rounded w-100 mb-2">
            </div>
            <div class="col-12 col-md-4 ps-5">
                <h5><a href="{{ route('blog.details', $featuredBlog->slug) }}" class="text-base">{{ $featuredBlog->title }}</a></h5>
                <p class="mt-5">{{ substr(strip_tags(__($featuredBlog->description)), 0, 500) . '...' }}</p>
            </div>
        </div>
        <hr class="mt-5">
        @endif

        <div class="row g-5 mt-4">
            @foreach ($blogs as $item)

            @php
            $truncated_title = \Str::of(strip_tags(__($item->title)))->limit(80, '...');
            @endphp

            <div class="col-md-4 col-6 mt-4">
                <img src="{{getImage(getFilePath('blog').'/'.$item->featured_image)}}" alt="{{ $item->title }}" class="rounded w-100 h-75">
                <h5 class="mt-2"><a href="{{ route('blog.details', $item->slug) }}" class="text-base">{{ $truncated_title }}</a></h5>
                <small>{{ date('d M Y', strtotime($item->created_at)) }}</small>
            </div>

            @endforeach
            <div class="col-md-12">
                <nav>
                    <ul class="pagination mt-3">
                        @if ($blogs->hasPages())
                        <div class="py-4">
                            {{ paginateLinks($blogs) }}
                        </div>
                        @endif
                    </ul>
                </nav>
            </div>
        </div>
    </div>
</section>
<!-- ==================== Service End Here ==================== -->

@if($sections->secs != null)
@foreach(json_decode($sections->secs) as $sec)
@include($activeTemplate.'sections.'.$sec)
@endforeach
@endif
@endsection
